// ChannelWindow.cpp : implementation file
//

#include "stdafx.h"
#include "Multiplexer.h"
#include "ChannelWindow.h"
#include "MultiplexerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BYTE g_n_splits_division;

extern VOID Dbg( CHAR* , ... );

/////////////////////////////////////////////////////////////////////////////
// CChannelWindow

CChannelWindow::CChannelWindow()
{
}

CChannelWindow::~CChannelWindow()
{
}


BEGIN_MESSAGE_MAP(CChannelWindow, CWnd)
	//{{AFX_MSG_MAP(CChannelWindow)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChannelWindow message handlers

BOOL CChannelWindow::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CMultiplexerDlg* pMainDlg = (CMultiplexerDlg* )( GetParent() );

	ULONG nChannelNumber = GetDlgCtrlID();

	BOOL bEraseBkgnd = FALSE;

	if( ( nChannelNumber & 0xF0000000 ) == 0x00000000 )
	{		
		if( pMainDlg->m_hVideoDevice[ nChannelNumber ] == 0xFFFFFFFF )
		{
			bEraseBkgnd = TRUE;
		}
	}

	if( bEraseBkgnd ) {

		CRect rect_client;
		
		GetClientRect( &rect_client );
		
		CBrush brush_fill_rect( RGB( 192, 192, 192 ) );

		pDC->FillRect( &rect_client, &brush_fill_rect );


		// fill in the text 
		CFont font;

		Dbg( "rect_client.Width = %d", rect_client.Width() );

		ULONG nRation = (GetSystemMetrics( SM_CXSCREEN ) / 2) / rect_client.Width();

		ULONG nMode = (GetSystemMetrics( SM_CXSCREEN ) / 2) % rect_client.Width();

		// when full screen
		if ( nRation == 0 ) { nRation =1; }

		ULONG nFontSize = (300 / nRation) - nMode;
		
		font.CreatePointFont( nFontSize, TEXT( "Arial" ), NULL );

		pDC->SelectObject( &font );

		pDC->SetBkMode( TRANSPARENT );

		CString string = TEXT( "No Signal" );

		pDC->SetTextColor( RGB( 0, 0, 0 ) );

		pDC->DrawText( string, &rect_client, DT_SINGLELINE| DT_CENTER | DT_VCENTER );
		
	}
	else //have signal 
	{
		CRect rect_client;
			
		GetClientRect( &rect_client );

		CBrush brush_fill_rect( RGB( 0, 0, 255) );

		pDC->FillRect( &rect_client, &brush_fill_rect );	
	}

	return TRUE;	

	return CWnd::OnEraseBkgnd(pDC);
}

void CChannelWindow::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	CMultiplexerDlg* pParent = (CMultiplexerDlg*)(GetParent());
	
	ULONG nChannelNum = GetDlgCtrlID();

	pParent->OnLButtonDown_CChannelWindow( nChannelNum, nFlags, point);

	CWnd::OnLButtonDown(nFlags, point);
}

void CChannelWindow::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CMultiplexerDlg *pParent = (CMultiplexerDlg* )(GetParent());
	
	ULONG nChannelNum = GetDlgCtrlID();

	pParent->m_nDisplayModeNumber = nChannelNum;

	ClientToScreen( &point );

	pParent->OnRButtonDown_CChannelWindow( nChannelNum, point, this );	

	CWnd::OnRButtonDown(nFlags, point);
}
